package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.bd.dashboard.query.Indicator09Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.indicators.core.IndicatorTable;
import org.msh.utils.reportgen.highchart.ChartCreator;
import org.msh.utils.reportgen.highchart.ChartOptions;
import org.msh.utils.reportgen.highchart.Series;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created by Mauricio on 15/05/2017.
 */
@Name("detailedIndicator09")
public class DetailedIndicator09 extends DetailedIndicator<Indicator09Query> {

    @Override
    protected void createIndicators() {

        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);

        List<Object[]> result = getQuery().getDetailedResult();

        // check root name
        String rootLabel = auSelected == null ? "Bangladesh" : auSelected.getCountryStructure().getName() + ": " + auSelected.getName().getName1();

        // populate indicator table
        for(Object[] r : result){
            String adminUnit = (String) r[0];
            Long newCasesConverted = (Long) r[1];
            Long newCasesTotal = (Long) r[2];
            Float rate1 = (Float) r[3];
            Long retreatCasesConverted = (Long) r[4];
            Long retreatCasesTotal = (Long) r[5];
            Float rate2 = (Float) r[6];

            if (adminUnit.equals("root")) {
                adminUnit = rootLabel;
            }

            addValue(getMessage("dashboard.indicator09.new"), adminUnit, newCasesConverted != null ? newCasesConverted.floatValue() : 0);
            addValue(getMessage("dashboard.indicator09.new.all"), adminUnit, newCasesTotal != null ? newCasesTotal.floatValue() : 0);
            addValue(getMessage("dashboard.indicator09.new.rate"), adminUnit, rate1);
            addValue(getMessage("dashboard.indicator09.retreat"), adminUnit, retreatCasesConverted != null ? retreatCasesConverted.floatValue() : 0);
            addValue(getMessage("dashboard.indicator09.retreat.all"), adminUnit, retreatCasesTotal != null ? retreatCasesTotal.floatValue() : 0);
            addValue(getMessage("dashboard.indicator09.retreat.rate"), adminUnit, rate2);
        }

        // set highlight in root row
        getTable().getRows().get(getTable().getRows().size()-1).setHighlight(true);
    }

    @Override
    protected Indicator09Query getQueryNewInstance() {
        return new Indicator09Query();
    }

    @Override
    protected void createChartData() {
        if (getTable() == null)
            return;

        chartCreator = new ChartCreator();
        ChartOptions opt = chartCreator.getOptions();
        opt.getChart().setRenderTo("chartdiv");
        opt.getChart().setType(getIndicatorFilters().getHighChartType());

        Series newSeries = opt.addSeries();
        Series retreatSeries = opt.addSeries();

        String newRateColumnLabel = Messages.instance().get("dashboard.indicator09.new.rate");
        String retreatRateColumnLabel = Messages.instance().get("dashboard.indicator09.retreat.rate");

        newSeries.setName(newRateColumnLabel);
        retreatSeries.setName(retreatRateColumnLabel);

        for (IndicatorTable.TableRow row: getTable().getRows()) {
            for (IndicatorTable.TableCell cell: row.getCells()) {
                if (cell.getColumn().getTitle() != null && cell.getValue() != null &&
                        (cell.getColumn().getTitle().equals(newRateColumnLabel) || cell.getColumn().getTitle().equals(retreatRateColumnLabel))) {

                    if (!opt.getxAxis().getCategories().contains(cell.getRow().getTitle())) {
                        opt.getxAxis().getCategories().add(cell.getRow().getTitle());
                    }

                    if (cell.getColumn().getTitle().equals(newRateColumnLabel)) {
                        BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(2, RoundingMode.HALF_EVEN);
                        newSeries.addNewValue(bd.doubleValue());
                    } else if (cell.getColumn().getTitle().equals(retreatRateColumnLabel)) {
                        BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(2, RoundingMode.HALF_EVEN);
                        retreatSeries.addNewValue(bd.doubleValue());
                    }
                }
            }
        }

        opt.getTitle().setText(Messages.instance().get("dashboard.indicator09"));
    }
}
